<?php
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Fix Config - Create Missing Files</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        h1 { color: #333; }
        .success { background: #d4edda; color: #155724; padding: 15px; border-radius: 4px; margin: 10px 0; }
        .error { background: #f8d7da; color: #721c24; padding: 15px; border-radius: 4px; margin: 10px 0; }
        .info { background: #d1ecf1; color: #0c5460; padding: 15px; border-radius: 4px; margin: 10px 0; }
        button { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; }
        button:hover { background: #0056b3; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Fix Config Files</h1>
        <p>Script ini akan membuat file config yang missing jika belum ada.</p>
        
        <?php
        $baseDir = __DIR__;
        $configDir = $baseDir . '/config';
        $errors = [];
        $success = [];
        
        if (!is_dir($configDir)) {
            if (@mkdir($configDir, 0755, true)) {
                $success[] = "Folder config/ berhasil dibuat";
            } else {
                $errors[] = "Gagal membuat folder config/. Pastikan permission folder parent adalah 755.";
            }
        } else {
            $success[] = "Folder config/ sudah ada";
        }
        
        $databaseFile = $configDir . '/database.php';
        if (!file_exists($databaseFile)) {
            $databaseContent = '<?php
define("DB_HOST", "localhost");
define("DB_USER", "root");
define("DB_PASS", "");
define("DB_NAME", "whm_admin");

function createDatabaseIfNotExists() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS);
    if ($conn->connect_error) {
        return false;
    }
    $result = $conn->query("SHOW DATABASES LIKE \'" . DB_NAME . "\'");
    if ($result && $result->num_rows == 0) {
        $sql = "CREATE DATABASE `" . DB_NAME . "` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
        @$conn->query($sql);
    }
    $conn->close();
    return true;
}

function getDBConnection() {
    @createDatabaseIfNotExists();
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        if (strpos($conn->connect_error, "Unknown database") !== false) {
            die("Database \'" . DB_NAME . "\' tidak ditemukan. Silakan buat database terlebih dahulu via cPanel MySQL atau phpMyAdmin.");
        }
        die("Connection failed: " . $conn->connect_error);
    }
    return $conn;
}

function initDatabase() {
    try {
        $conn = getDBConnection();
        $conn->set_charset("utf8mb4");
        $sql = "CREATE TABLE IF NOT EXISTS clients (
            id INT PRIMARY KEY AUTO_INCREMENT,
            domain VARCHAR(255) UNIQUE NOT NULL,
            api_key VARCHAR(64) UNIQUE NOT NULL,
            template_selected VARCHAR(50) NOT NULL,
            status ENUM(\'pending\', \'active\', \'suspended\') DEFAULT \'pending\',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        $conn->query($sql);
        $sql = "CREATE TABLE IF NOT EXISTS templates (
            id INT PRIMARY KEY AUTO_INCREMENT,
            name VARCHAR(100) NOT NULL,
            folder_name VARCHAR(100) NOT NULL,
            description TEXT,
            zip_file_path VARCHAR(255) NOT NULL,
            is_active BOOLEAN DEFAULT 1,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        $conn->query($sql);
        $sql = "CREATE TABLE IF NOT EXISTS installations (
            id INT PRIMARY KEY AUTO_INCREMENT,
            client_id INT,
            api_key VARCHAR(64),
            template_id INT,
            install_status ENUM(\'pending\', \'downloading\', \'extracting\', \'completed\', \'failed\') DEFAULT \'pending\',
            install_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            error_message TEXT,
            INDEX idx_client_id (client_id),
            INDEX idx_api_key (api_key)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        $conn->query($sql);
        $sql = "CREATE TABLE IF NOT EXISTS admin_users (
            id INT PRIMARY KEY AUTO_INCREMENT,
            username VARCHAR(50) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            email VARCHAR(100),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        $conn->query($sql);
        $checkAdmin = $conn->query("SELECT COUNT(*) as count FROM admin_users WHERE username = \'admin\'");
        if ($checkAdmin) {
            $row = $checkAdmin->fetch_assoc();
            if ($row[\'count\'] == 0) {
                $password = password_hash(\'admin123\', PASSWORD_DEFAULT);
                $conn->query("INSERT INTO admin_users (username, password, email) VALUES (\'admin\', \'$password\', \'admin@example.com\')");
            }
        }
        $conn->close();
        return true;
    } catch (Exception $e) {
        return false;
    }
}
initDatabase();
?>';
            
            if (@file_put_contents($databaseFile, $databaseContent)) {
                @chmod($databaseFile, 0644);
                $success[] = "File config/database.php berhasil dibuat";
            } else {
                $errors[] = "Gagal membuat file config/database.php. Pastikan permission folder config/ adalah 755.";
            }
        } else {
            $success[] = "File config/database.php sudah ada";
        }
        
        $configFile = $configDir . '/config.php';
        if (!file_exists($configFile)) {
            $configContent = '<?php
function getBaseUrl() {
    $protocol = (!empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off") ? "https" : "http";
    $host = $_SERVER["HTTP_HOST"];
    $scriptDir = dirname($_SERVER["SCRIPT_NAME"]);
    if (strpos($scriptDir, "/405server") !== false) {
        $basePath = rtrim($scriptDir, "/");
    } elseif (strpos($scriptDir, "/server-admin") !== false) {
        $basePath = rtrim($scriptDir, "/");
    } else {
        $configDir = dirname(__FILE__);
        $parentDir = basename(dirname($configDir));
        if ($parentDir === "405server" || $parentDir === "server-admin") {
            $basePath = dirname($scriptDir) . "/" . $parentDir;
        } else {
            $basePath = "/server-admin";
        }
    }
    return $protocol . "://" . $host . $basePath;
}
$manualBaseUrl = "https://stock-market-idea.com/server-admin";
define("ADMIN_BASE_URL", $manualBaseUrl !== null ? $manualBaseUrl : getBaseUrl());
define("TEMPLATES_DIR", __DIR__ . "/../templates/");
define("INSTALLER_DIR", __DIR__ . "/../installers/");
define("API_KEY_LENGTH", 32);
define("SESSION_NAME", "whm_admin_session");
define("RATE_LIMIT_REQUESTS", 10);
define("API_KEY_EXPIRY_DAYS", 365);
date_default_timezone_set("Asia/Jakarta");
if (strpos($_SERVER["HTTP_HOST"], "localhost") !== false || strpos($_SERVER["HTTP_HOST"], "127.0.0.1") !== false) {
    error_reporting(E_ALL);
    ini_set("display_errors", 1);
} else {
    error_reporting(0);
    ini_set("display_errors", 0);
}
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}
function generateApiKey() {
    return bin2hex(random_bytes(API_KEY_LENGTH));
}
function sanitizeInput($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}
function isLoggedIn() {
    return isset($_SESSION["admin_logged_in"]) && $_SESSION["admin_logged_in"] === true;
}
function requireLogin() {
    if (!isLoggedIn()) {
        $scriptDir = dirname($_SERVER["SCRIPT_NAME"]);
        if (strpos($scriptDir, "/405server") !== false) {
            $loginUrl = "/405server/login.php";
        } elseif (strpos($scriptDir, "/server-admin") !== false) {
            $loginUrl = "/server-admin/login.php";
        } else {
            $loginUrl = "login.php";
        }
        header("Location: " . $loginUrl);
        exit;
    }
}
function autoSetup() {
    $dirs = [TEMPLATES_DIR, INSTALLER_DIR, __DIR__ . "/../assets/css", __DIR__ . "/../api", __DIR__ . "/../logs"];
    foreach ($dirs as $dir) {
        if (!is_dir($dir)) {
            @mkdir($dir, 0755, true);
        }
    }
    $htaccessFile = TEMPLATES_DIR . ".htaccess";
    if (!file_exists($htaccessFile)) {
        $htaccessContent = "Options -Indexes\nDeny from all";
        @file_put_contents($htaccessFile, $htaccessContent);
    }
    $htaccessFile2 = INSTALLER_DIR . ".htaccess";
    if (!file_exists($htaccessFile2)) {
        $htaccessContent = "Options -Indexes\n";
        @file_put_contents($htaccessFile2, $htaccessContent);
    }
    $indexFile = TEMPLATES_DIR . "index.php";
    if (!file_exists($indexFile)) {
        @file_put_contents($indexFile, "<?php\n// Directory access denied\n");
    }
    $requiredExtensions = ["mysqli", "zip", "json"];
    $missingExtensions = [];
    foreach ($requiredExtensions as $ext) {
        if (!extension_loaded($ext)) {
            $missingExtensions[] = $ext;
        }
    }
    return ["success" => empty($missingExtensions), "missing_extensions" => $missingExtensions, "directories_created" => true];
}
$setupStatus = autoSetup();
?>';
            
            if (@file_put_contents($configFile, $configContent)) {
                @chmod($configFile, 0644);
                $success[] = "File config/config.php berhasil dibuat";
            } else {
                $errors[] = "Gagal membuat file config/config.php. Pastikan permission folder config/ adalah 755.";
            }
        } else {
            $success[] = "File config/config.php sudah ada";
        }
        
        if (!empty($success)) {
            echo '<div class="success"><strong>SUCCESS:</strong><ul>';
            foreach ($success as $msg) {
                echo '<li>' . htmlspecialchars($msg) . '</li>';
            }
            echo '</ul></div>';
        }
        
        if (!empty($errors)) {
            echo '<div class="error"><strong>ERROR:</strong><ul>';
            foreach ($errors as $msg) {
                echo '<li>' . htmlspecialchars($msg) . '</li>';
            }
            echo '</ul></div>';
        }
        
        if (empty($errors) && file_exists($databaseFile) && file_exists($configFile)) {
            echo '<div class="success">';
            echo '<strong>✓ Semua file config sudah siap!</strong><br><br>';
            echo '<a href="../login.php" style="display: inline-block; padding: 10px 20px; background: #28a745; color: white; text-decoration: none; border-radius: 4px; margin-top: 10px;">Klik di sini untuk Login</a>';
            echo '</div>';
        } else {
            echo '<div class="info">';
            echo '<strong>⚠ PENTING:</strong><br>';
            echo 'Jika file tidak bisa dibuat otomatis, silakan:<br>';
            echo '1. Upload folder config/ secara manual via FTP/cPanel<br>';
            echo '2. Pastikan file database.php dan config.php ada di dalamnya<br>';
            echo '3. Set permission folder config/ menjadi 755<br>';
            echo '4. Set permission file menjadi 644';
            echo '</div>';
        }
        ?>
    </div>
</body>
</html>

