<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Auto Create Database - 405 Admin Panel</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #0a0a0f; color: #e8e8f0; }
        .container { max-width: 800px; margin: 0 auto; background: rgba(21, 21, 32, 0.8); padding: 30px; border-radius: 12px; border: 1px solid rgba(6, 182, 212, 0.3); }
        h1 { color: #06b6d4; margin-bottom: 20px; }
        pre { background: rgba(0, 0, 0, 0.3); padding: 15px; border-radius: 6px; overflow-x: auto; }
        .success { color: #14b8a6; }
        .error { color: #ff3366; }
        .warning { color: #fbbf24; }
        a { color: #06b6d4; text-decoration: none; }
        a:hover { text-decoration: underline; }
        .info-box { background: rgba(6, 182, 212, 0.15); padding: 15px; border-radius: 6px; margin: 20px 0; border: 1px solid rgba(6, 182, 212, 0.3); }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Auto Create Database</h1>
        
        <?php
        require_once __DIR__ . '/../config/database.php';
        require_once __DIR__ . '/../config/config.php';
        
        echo "<pre>";
        
        try {
            // Connect tanpa database name (untuk create database)
            $conn = new mysqli(DB_HOST, DB_USER, DB_PASS);
            
            if ($conn->connect_error) {
                echo "<span class='error'>❌ Connection failed: " . htmlspecialchars($conn->connect_error) . "</span>\n\n";
                echo "<div class='info-box'>";
                echo "<strong>⚠️ Pastikan:</strong><br>";
                echo "1. DB_HOST benar (biasanya 'localhost')<br>";
                echo "2. DB_USER benar (dari cPanel MySQL)<br>";
                echo "3. DB_PASS benar (dari cPanel MySQL)<br>";
                echo "4. User memiliki privilege untuk CREATE DATABASE<br><br>";
                echo "Jika belum setup, buka: <a href='../setup_database.php'>setup_database.php</a>";
                echo "</div>";
            } else {
                echo "<span class='success'>✓ Connected to MySQL</span>\n\n";
                
                // Check if database exists
                $result = $conn->query("SHOW DATABASES LIKE '" . DB_NAME . "'");
                
                if ($result && $result->num_rows > 0) {
                    echo "<span class='warning'>⚠ Database '" . DB_NAME . "' already exists!</span>\n\n";
                } else {
                    // Create database
                    $sql = "CREATE DATABASE `" . DB_NAME . "` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
                    
                    if ($conn->query($sql) === TRUE) {
                        echo "<span class='success'>✅ Database '" . DB_NAME . "' created successfully!</span>\n\n";
                    } else {
                        echo "<span class='error'>❌ Error creating database: " . htmlspecialchars($conn->error) . "</span>\n";
                        echo "\n<div class='info-box'>";
                        echo "Jika error 'Access denied', user database tidak memiliki privilege CREATE DATABASE.<br>";
                        echo "Solusi: Buat database manual via cPanel → MySQL Databases → Create Database";
                        echo "</div>";
                    }
                }
                
                $conn->close();
                
                // Now connect to the database and create tables
                echo "\n<span class='success'>📋 Initializing database tables...</span>\n\n";
                
                $conn = getDBConnection();
                initDatabase();
                
                echo "<span class='success'>✅ Database and tables initialized successfully!</span>\n\n";
                
                // Check admin user
                $result = $conn->query("SELECT id, username FROM admin_users WHERE username = 'admin'");
                if ($result && $result->num_rows > 0) {
                    $user = $result->fetch_assoc();
                    echo "<span class='success'>✓ Admin user exists (ID: {$user['id']}, Username: {$user['username']})</span>\n";
                } else {
                    echo "<span class='warning'>⚠ Admin user not found. Creating default admin user...</span>\n";
                    $password = password_hash('admin123', PASSWORD_DEFAULT);
                    $conn->query("INSERT INTO admin_users (username, password, email) VALUES ('admin', '$password', 'admin@example.com')");
                    echo "<span class='success'>✓ Default admin user created!</span>\n";
                }
                
                $conn->close();
                
                echo "\n<div class='info-box'>";
                echo "<strong>🎉 Setup Complete!</strong><br><br>";
                echo "Next steps:<br>";
                echo "1. <a href='../login.php'>Go to Login Page</a><br>";
                echo "2. Login with: <strong>admin</strong> / <strong>admin123</strong><br>";
                echo "3. Change default password after first login";
                echo "</div>";
            }
            
        } catch (Exception $e) {
            echo "<span class='error'>❌ Error: " . htmlspecialchars($e->getMessage()) . "</span>\n\n";
            echo "<div class='info-box'>";
            echo "<strong>Manual Setup:</strong><br>";
            echo "1. Login ke cPanel → phpMyAdmin<br>";
            echo "2. Buat database baru: <strong>" . DB_NAME . "</strong><br>";
            echo "3. Atau buka: <a href='../setup_database.php'>setup_database.php</a> untuk setup otomatis";
            echo "</div>";
        }
        
        echo "</pre>";
        ?>
        
        <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid rgba(6, 182, 212, 0.2);">
            <a href="../login.php">← Back to Login</a> | 
            <a href="../setup_database.php">Setup Database Config</a> | 
            <a href="../debug_login.php">Debug Login</a>
        </div>
    </div>
</body>
</html>

