<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Test Database Connection - 405 Admin Panel</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #0a0a0f; color: #e8e8f0; }
        .container { max-width: 700px; margin: 0 auto; background: rgba(21, 21, 32, 0.8); padding: 30px; border-radius: 12px; border: 1px solid rgba(6, 182, 212, 0.3); }
        h1 { color: #06b6d4; margin-bottom: 20px; }
        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; color: #b0b0c0; font-weight: 500; }
        input { width: 100%; padding: 10px; border: 1px solid rgba(6, 182, 212, 0.3); border-radius: 6px; background: rgba(15, 15, 21, 0.6); color: #e8e8f0; font-size: 14px; box-sizing: border-box; }
        input:focus { outline: none; border-color: #06b6d4; box-shadow: 0 0 0 3px rgba(6, 182, 212, 0.2); }
        button { padding: 12px 24px; background: linear-gradient(135deg, #06b6d4 0%, #14b8a6 100%); color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: 600; }
        button:hover { opacity: 0.9; }
        .info { background: rgba(6, 182, 212, 0.15); padding: 15px; border-radius: 6px; margin-bottom: 20px; border: 1px solid rgba(6, 182, 212, 0.3); }
        .success { background: rgba(20, 184, 166, 0.15); padding: 15px; border-radius: 6px; margin-top: 20px; border: 1px solid rgba(20, 184, 166, 0.3); }
        .error { background: rgba(255, 51, 102, 0.15); padding: 15px; border-radius: 6px; margin-top: 20px; border: 1px solid rgba(255, 51, 102, 0.3); color: #ff3366; }
        .warning { background: rgba(251, 191, 36, 0.15); padding: 15px; border-radius: 6px; margin-top: 20px; border: 1px solid rgba(251, 191, 36, 0.3); color: #fbbf24; }
        code { background: rgba(0, 0, 0, 0.3); padding: 2px 6px; border-radius: 3px; }
        pre { background: rgba(0, 0, 0, 0.3); padding: 15px; border-radius: 6px; overflow-x: auto; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Test Database Connection</h1>
        
        <div class="info">
            <strong>📋 Cara mendapatkan kredensial yang benar:</strong><br><br>
            1. Login ke cPanel → <strong>MySQL Databases</strong><br>
            2. Di bagian <strong>"Current Users"</strong>, copy username lengkap (contoh: <code>stockmar_King</code>)<br>
            3. Jika user belum ada, buat user baru di bagian <strong>"Add New User"</strong><br>
            4. Untuk password, pastikan copy-paste langsung (jangan ketik manual karena case-sensitive)
        </div>

        <?php
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $db_host = $_POST['db_host'] ?? 'localhost';
            $db_user = $_POST['db_user'] ?? '';
            $db_pass = $_POST['db_pass'] ?? '';
            
            echo '<div class="info">';
            echo '<strong>Testing connection...</strong><br>';
            echo 'Host: <code>' . htmlspecialchars($db_host) . '</code><br>';
            echo 'User: <code>' . htmlspecialchars($db_user) . '</code><br>';
            echo 'Password: <code>' . str_repeat('*', strlen($db_pass)) . '</code> (' . strlen($db_pass) . ' characters)<br>';
            echo '</div>';
            
            if (empty($db_user)) {
                echo '<div class="error">❌ DB User tidak boleh kosong!</div>';
            } else {
                // Test connection
                $test_conn = @new mysqli($db_host, $db_user, $db_pass);
                
                if ($test_conn->connect_error) {
                    $error_msg = $test_conn->connect_error;
                    echo '<div class="error">❌ Connection FAILED!</div>';
                    echo '<pre>' . htmlspecialchars($error_msg) . '</pre>';
                    
                    echo '<div class="warning">';
                    echo '<strong>🔍 Troubleshooting Steps:</strong><br><br>';
                    
                    if (strpos($error_msg, 'Access denied') !== false) {
                        echo '<strong>1. Cek Username:</strong><br>';
                        echo '   - Pastikan username LENGKAP dari cPanel (contoh: <code>stockmar_King</code>)<br>';
                        echo '   - Bukan hanya <code>King</code> atau <code>stockmar</code><br>';
                        echo '   - Copy-paste langsung dari cPanel untuk menghindari typo<br><br>';
                        
                        echo '<strong>2. Cek Password:</strong><br>';
                        echo '   - Password case-sensitive (huruf besar/kecil berpengaruh)<br>';
                        echo '   - Copy-paste langsung dari cPanel<br>';
                        echo '   - Pastikan tidak ada spasi di awal/akhir<br>';
                        echo '   - Jika password mengandung karakter khusus (@, #, $, dll), pastikan diketik dengan benar<br><br>';
                        
                        echo '<strong>3. Cek User di cPanel:</strong><br>';
                        echo '   - Login ke cPanel → MySQL Databases<br>';
                        echo '   - Di bagian "Current Users", pastikan user <code>' . htmlspecialchars($db_user) . '</code> ada<br>';
                        echo '   - Jika tidak ada, buat user baru:<br>';
                        echo '     * Klik "Add New User"<br>';
                        echo '     * Username: <code>King</code> (akan otomatis menjadi <code>stockmar_King</code>)<br>';
                        echo '     * Password: <code>Kingisback2025@</code><br>';
                        echo '     * Klik "Create User"<br><br>';
                        
                        echo '<strong>4. Reset Password (jika perlu):</strong><br>';
                        echo '   - Di cPanel → MySQL Databases → Current Users<br>';
                        echo '   - Klik "Change Password" untuk user yang ingin direset<br>';
                        echo '   - Set password baru dan catat dengan benar<br><br>';
                        
                        echo '<strong>5. Alternatif: Gunakan User yang Sudah Ada</strong><br>';
                        echo '   - Di cPanel → MySQL Databases → Current Users<br>';
                        echo '   - Gunakan user yang sudah ada dan Anda tahu passwordnya<br>';
                        echo '   - Atau buat user baru dengan password yang lebih sederhana (tanpa karakter khusus)';
                    } else {
                        echo 'Error: ' . htmlspecialchars($error_msg) . '<br>';
                        echo 'Pastikan DB_HOST benar (biasanya "localhost")';
                    }
                    echo '</div>';
                } else {
                    echo '<div class="success">✅ Connection SUCCESS!</div>';
                    
                    // Test queries
                    echo '<div class="info">';
                    echo '<strong>Testing database operations...</strong><br><br>';
                    
                    // Show databases
                    $result = $test_conn->query("SHOW DATABASES");
                    if ($result) {
                        echo '<strong>Available databases:</strong><br>';
                        while ($row = $result->fetch_array()) {
                            echo '- <code>' . htmlspecialchars($row[0]) . '</code><br>';
                        }
                    }
                    
                    // Check privileges
                    $result = $test_conn->query("SHOW GRANTS FOR CURRENT_USER()");
                    if ($result) {
                        echo '<br><strong>User privileges:</strong><br>';
                        while ($row = $result->fetch_array()) {
                            echo '<code>' . htmlspecialchars($row[0]) . '</code><br>';
                        }
                    }
                    
                    echo '</div>';
                    
                    echo '<div class="success">';
                    echo '<strong>🎉 Kredensial Anda BENAR!</strong><br><br>';
                    echo 'Sekarang Anda bisa:<br>';
                    echo '1. Buka: <a href="setup_database.php" style="color: #06b6d4;">setup_database.php</a> untuk setup database<br>';
                    echo '2. Atau edit manual file <code>config/database.php</code> dengan kredensial ini';
                    echo '</div>';
                    
                    $test_conn->close();
                }
            }
        }
        ?>
        
        <form method="POST">
            <div class="form-group">
                <label>DB_HOST</label>
                <input type="text" name="db_host" value="localhost" required>
            </div>
            
            <div class="form-group">
                <label>DB_USER (username lengkap dari cPanel)</label>
                <input type="text" name="db_user" value="stockmar_King" placeholder="contoh: stockmar_King" required>
                <small style="color: #b0b0c0; font-size: 12px; display: block; margin-top: 5px;">
                    ⚠️ Copy-paste langsung dari cPanel → MySQL Databases → Current Users
                </small>
            </div>
            
            <div class="form-group">
                <label>DB_PASS (password dari cPanel - TANPA karakter khusus!)</label>
                <input type="password" name="db_pass" value="Kingisback2025" placeholder="Password database (tanpa @, #, $)" required>
                <small style="color: #ff3366; font-size: 12px; display: block; margin-top: 5px;">
                    ⚠️ PENTING: Gunakan password TANPA karakter khusus (@, #, $, dll)!
                </small>
            </div>
            
            <button type="submit">🔍 Test Connection</button>
        </form>
        
        <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid rgba(6, 182, 212, 0.2);">
            <a href="setup_database.php">← Back to Setup Database</a> | 
            <a href="login.php">Go to Login</a>
        </div>
    </div>
</body>
</html>

