<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Setup Database - 405 Admin Panel</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #0a0a0f; color: #e8e8f0; }
        .container { max-width: 600px; margin: 0 auto; background: rgba(21, 21, 32, 0.8); padding: 30px; border-radius: 12px; border: 1px solid rgba(6, 182, 212, 0.3); }
        h1 { color: #06b6d4; margin-bottom: 20px; }
        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; color: #b0b0c0; font-weight: 500; }
        input { width: 100%; padding: 10px; border: 1px solid rgba(6, 182, 212, 0.3); border-radius: 6px; background: rgba(15, 15, 21, 0.6); color: #e8e8f0; font-size: 14px; }
        input:focus { outline: none; border-color: #06b6d4; box-shadow: 0 0 0 3px rgba(6, 182, 212, 0.2); }
        button { padding: 12px 24px; background: linear-gradient(135deg, #06b6d4 0%, #14b8a6 100%); color: white; border: none; border-radius: 6px; cursor: pointer; font-weight: 600; }
        button:hover { opacity: 0.9; }
        .info { background: rgba(6, 182, 212, 0.15); padding: 15px; border-radius: 6px; margin-bottom: 20px; border: 1px solid rgba(6, 182, 212, 0.3); }
        .success { background: rgba(20, 184, 166, 0.15); padding: 15px; border-radius: 6px; margin-top: 20px; border: 1px solid rgba(20, 184, 166, 0.3); }
        .error { background: rgba(255, 51, 102, 0.15); padding: 15px; border-radius: 6px; margin-top: 20px; border: 1px solid rgba(255, 51, 102, 0.3); color: #ff3366; }
        code { background: rgba(0, 0, 0, 0.3); padding: 2px 6px; border-radius: 3px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Setup Database Configuration</h1>
        
        <div class="info">
            <strong>📋 Cara mendapatkan kredensial MySQL dari cPanel:</strong><br><br>
            1. Login ke cPanel<br>
            2. Buka <strong>MySQL Databases</strong><br>
            3. Di bagian <strong>"Current Users"</strong>, copy username lengkap (contoh: <code>stockmar_King</code>)<br>
            4. Jika user belum ada, buat di bagian <strong>"Add New User"</strong><br>
            5. Untuk password, copy-paste langsung dari cPanel (case-sensitive)<br><br>
            <strong>⚠️ Jika masih error, coba: <a href="test_db_connection.php" style="color: #06b6d4;">Test Connection</a> terlebih dahulu</strong>
        </div>

        <?php
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $db_host = $_POST['db_host'] ?? 'localhost';
            $db_user = $_POST['db_user'] ?? '';
            $db_pass = $_POST['db_pass'] ?? '';
            $db_name = $_POST['db_name'] ?? 'whm_admin';
            
            if (empty($db_user)) {
                echo '<div class="error">❌ DB User tidak boleh kosong!</div>';
            } else {
                // Test connection
                $test_conn = @new mysqli($db_host, $db_user, $db_pass);
                
                if ($test_conn->connect_error) {
                    $error_msg = $test_conn->connect_error;
                    echo '<div class="error">❌ Connection Error: ' . htmlspecialchars($error_msg) . '</div>';
                    
                    echo '<div class="info">';
                    echo '<strong>🔍 Troubleshooting:</strong><br><br>';
                    
                    if (strpos($error_msg, 'Access denied') !== false) {
                        echo '<strong>Error: Access Denied</strong><br>';
                        echo 'Kemungkinan penyebab:<br>';
                        echo '1. <strong>User belum dibuat</strong> - User <code>' . htmlspecialchars($db_user) . '</code> belum ada di cPanel MySQL<br>';
                        echo '2. <strong>Password salah</strong> - Password tidak cocok dengan yang di cPanel<br>';
                        echo '3. <strong>Username salah</strong> - Pastikan username lengkap dari cPanel<br><br>';
                        echo '<div class="warning">';
                        echo '<strong>🔧 SOLUSI CEPAT:</strong><br><br>';
                        echo '<strong>Opsi 1: Buat User Baru (Disarankan)</strong><br>';
                        echo '1. Login ke cPanel → MySQL Databases<br>';
                        echo '2. Di bagian "Add New User":<br>';
                        echo '   - Username: <code>King</code> (akan otomatis menjadi <code>stockmar_King</code>)<br>';
                        echo '   - Password: Buat password SEDERHANA tanpa karakter khusus (contoh: <code>Kingisback2025</code>)<br>';
                        echo '   - Klik "Create User"<br>';
                        echo '3. Setelah user dibuat, gunakan kredensial baru di form ini<br><br>';
                        echo '<strong>Opsi 2: Gunakan User yang Sudah Ada</strong><br>';
                        echo '1. Di cPanel → MySQL Databases → Current Users<br>';
                        echo '2. Gunakan user yang sudah ada dan Anda tahu passwordnya<br>';
                        echo '3. Atau klik "Change Password" untuk reset password<br><br>';
                        echo '<strong>Opsi 3: Edit Manual database.php</strong><br>';
                        echo '1. Login ke cPanel → File Manager<br>';
                        echo '2. Masuk ke: <code>public_html/server-admin/config/</code><br>';
                        echo '3. Edit file: <code>database.php</code><br>';
                        echo '4. Ganti DB_USER dan DB_PASS dengan kredensial yang BENAR<br>';
                        echo '5. Save dan buka: <a href="tools/create_db_auto.php">tools/create_db_auto.php</a><br>';
                        echo '</div>';
                    } else {
                        echo 'Pastikan:<br>';
                        echo '- DB_HOST benar (biasanya "localhost")<br>';
                        echo '- DB_USER benar (dari cPanel MySQL)<br>';
                        echo '- DB_PASS benar (dari cPanel MySQL)<br>';
                    }
                    echo '</div>';
                } else {
                    // Check if database exists
                    $result = $test_conn->query("SHOW DATABASES LIKE '$db_name'");
                    if ($result && $result->num_rows == 0) {
                        // Create database
                        if ($test_conn->query("CREATE DATABASE `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci")) {
                            echo '<div class="success">✅ Database <code>' . htmlspecialchars($db_name) . '</code> berhasil dibuat!</div>';
                        } else {
                            echo '<div class="error">⚠️ Database tidak bisa dibuat otomatis. Silakan buat manual via phpMyAdmin.</div>';
                        }
                    }
                    
                    // Update database.php
                    $db_file = __DIR__ . '/config/database.php';
                    $db_content = file_get_contents($db_file);
                    
                    // Replace DB credentials
                    $db_content = preg_replace(
                        "/define\('DB_HOST',\s*'[^']*'\);/",
                        "define('DB_HOST', '" . addslashes($db_host) . "');",
                        $db_content
                    );
                    $db_content = preg_replace(
                        "/define\('DB_USER',\s*'[^']*'\);/",
                        "define('DB_USER', '" . addslashes($db_user) . "');",
                        $db_content
                    );
                    $db_content = preg_replace(
                        "/define\('DB_PASS',\s*'[^']*'\);/",
                        "define('DB_PASS', '" . addslashes($db_pass) . "');",
                        $db_content
                    );
                    $db_content = preg_replace(
                        "/define\('DB_NAME',\s*'[^']*'\);/",
                        "define('DB_NAME', '" . addslashes($db_name) . "');",
                        $db_content
                    );
                    
                    if (file_put_contents($db_file, $db_content)) {
                        echo '<div class="success">✅ File <code>config/database.php</code> berhasil diupdate!</div>';
                        
                        // Test connection with new credentials
                        try {
                            require_once $db_file;
                            $conn = getDBConnection();
                            initDatabase();
                            echo '<div class="success">✅ Database dan tabel berhasil diinisialisasi!</div>';
                            echo '<div class="success"><strong>🎉 Setup selesai! <a href="login.php" style="color: #06b6d4;">Klik di sini untuk login</a></strong></div>';
                        } catch (Exception $e) {
                            echo '<div class="error">⚠️ Error saat inisialisasi: ' . htmlspecialchars($e->getMessage()) . '</div>';
                            echo '<div class="info">File config sudah diupdate. Silakan buka: <a href="tools/create_db_auto.php">tools/create_db_auto.php</a> untuk membuat tabel.</div>';
                        }
                    } else {
                        echo '<div class="error">❌ Gagal menulis file. Pastikan permission folder config/ adalah 755 dan file database.php adalah 644.</div>';
                        echo '<div class="info">Anda bisa edit manual file <code>config/database.php</code> via cPanel File Manager.</div>';
                    }
                    
                    $test_conn->close();
                }
            }
        }
        ?>
        
        <form method="POST">
            <div class="form-group">
                <label>DB_HOST (biasanya "localhost")</label>
                <input type="text" name="db_host" value="localhost" required>
            </div>
            
            <div class="form-group">
                <label>DB_USER (dari cPanel MySQL)</label>
                <input type="text" name="db_user" placeholder="contoh: username_dbuser" required>
            </div>
            
            <div class="form-group">
                <label>DB_PASS (dari cPanel MySQL)</label>
                <input type="password" name="db_pass" placeholder="Password database Anda" required>
            </div>
            
            <div class="form-group">
                <label>DB_NAME (nama database)</label>
                <input type="text" name="db_name" value="whm_admin" required>
            </div>
            
            <button type="submit">💾 Save & Test Connection</button>
        </form>
        
        <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid rgba(6, 182, 212, 0.2);">
            <p style="color: #b0b0c0; font-size: 12px;">
                <strong>Catatan:</strong> Setelah setup selesai, hapus file ini untuk keamanan.<br>
                Atau akses: <a href="login.php" style="color: #06b6d4;">login.php</a> untuk masuk ke admin panel.
            </p>
        </div>
    </div>
</body>
</html>

