<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Netflix Template Installation</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Roboto', sans-serif;
            background: #000000;
            color: #e8e8f0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
        }
        .container {
            max-width: 500px;
            width: 100%;
            background: rgba(21, 21, 32, 0.9);
            backdrop-filter: blur(15px);
            border-radius: 16px;
            padding: 2.5rem;
            border: 1px solid rgba(6, 182, 212, 0.3);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5), 0 0 40px rgba(6, 182, 212, 0.2);
        }
        h1 {
            font-size: 1.75rem;
            margin-bottom: 0.5rem;
            color: #e8e8f0;
            text-align: center;
        }
        .subtitle {
            text-align: center;
            color: #b0b0c0;
            margin-bottom: 2rem;
            font-size: 0.875rem;
        }
        .steps {
            margin-bottom: 2rem;
        }
        .step {
            margin-bottom: 1.5rem;
            padding-left: 2rem;
            position: relative;
        }
        .step::before {
            content: counter(step-counter);
            counter-increment: step-counter;
            position: absolute;
            left: 0;
            top: 0;
            width: 28px;
            height: 28px;
            background: linear-gradient(135deg, #06b6d4 0%, #14b8a6 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 0.875rem;
            color: white;
        }
        .steps {
            counter-reset: step-counter;
        }
        .step-title {
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: #e8e8f0;
        }
        .step-desc {
            color: #b0b0c0;
            font-size: 0.875rem;
            line-height: 1.6;
        }
        .btn-download {
            width: 100%;
            padding: 1rem;
            background: linear-gradient(135deg, #06b6d4 0%, #14b8a6 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: block;
            text-align: center;
            box-shadow: 0 4px 15px rgba(6, 182, 212, 0.4);
        }
        .btn-download:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 25px rgba(6, 182, 212, 0.5);
        }
        .info-box {
            background: rgba(6, 182, 212, 0.1);
            border: 1px solid rgba(6, 182, 212, 0.3);
            border-radius: 8px;
            padding: 1rem;
            margin-top: 1.5rem;
            font-size: 0.875rem;
            color: #b0b0c0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Netflix Template Installation</h1>
        <p class="subtitle">Simple installation guide</p>
        
        <div class="steps">
            <div class="step">
                <div class="step-title">Download Installer</div>
                <div class="step-desc">Download installer.php file to your server</div>
            </div>
            
            <div class="step">
                <div class="step-title">Upload to Server</div>
                <div class="step-desc">Upload installer.php to your website root directory</div>
            </div>
            
            <div class="step">
                <div class="step-title">Enter API Key</div>
                <div class="step-desc">Open installer.php in browser and enter your API key</div>
            </div>
            
            <div class="step">
                <div class="step-title">Install Complete</div>
                <div class="step-desc">Template will be downloaded and extracted automatically</div>
            </div>
        </div>
        
        <a href="download_installer.php" class="btn-download">Download Installer.php</a>
        
        <div class="info-box" style="margin-top: 1.5rem;">
            <div style="margin-bottom: 1rem;">
                <strong style="color: #06b6d4; display: block; margin-bottom: 0.5rem;">How to Get API Key?</strong>
                <div style="line-height: 1.8;">
                    <p style="margin-bottom: 0.5rem;">1. Contact your administrator</p>
                    <p style="margin-bottom: 0.5rem;">2. Provide your domain name</p>
                    <p style="margin-bottom: 0.5rem;">3. Administrator will create your account and provide API key</p>
                    <p>4. Use the API key during installation</p>
                </div>
            </div>
            <div style="border-top: 1px solid rgba(6, 182, 212, 0.3); padding-top: 1rem; margin-top: 1rem;">
                <strong style="color: #06b6d4; display: block; margin-bottom: 0.5rem;">Installation Steps:</strong>
                <p style="margin-bottom: 0.5rem;">1. Download installer.php (button above)</p>
                <p style="margin-bottom: 0.5rem;">2. Upload installer.php to your website root directory</p>
                <p style="margin-bottom: 0.5rem;">3. Open installer.php in your browser</p>
                <p style="margin-bottom: 0.5rem;">4. Enter your API key when prompted</p>
                <p>5. Wait for automatic download and extraction</p>
            </div>
        </div>
    </div>
</body>
</html>
