<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/config/config.php';
requireLogin();

$conn = getDBConnection();
$templates = $conn->query("SELECT * FROM templates ORDER BY created_at DESC")->fetch_all(MYSQLI_ASSOC);
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Templates - WHM Admin</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
        }
        .template-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 1.75rem;
            margin-top: 2rem;
        }
    </style>
</head>
<body>
    <div class="admin-header">
        <h1>Manage Templates</h1>
        <div class="user-info">
            <a href="index.php" class="btn btn-primary btn-sm">Dashboard</a>
            <a href="add_template.php" class="btn btn-success btn-sm">Add Template</a>
        </div>
    </div>
    
    <div class="container">
        <div style="display: flex; justify-content: flex-end; margin-bottom: 1.5rem; gap: 0.5rem;">
            <a href="export_data.php?type=templates&format=csv" class="btn btn-primary btn-sm">Export CSV</a>
            <a href="export_data.php?type=templates&format=json" class="btn btn-primary btn-sm">Export JSON</a>
        </div>
        
        <?php if (empty($templates)): ?>
            <div class="card">
            <div class="empty-state">
                <div class="empty-state-icon">📦</div>
                <h3 style="margin-bottom: 0.5rem; color: var(--text-primary); font-size: 16px;">No Templates Yet</h3>
                <p style="margin-bottom: 1.5rem; color: var(--text-muted);">Get started by adding your first template.</p>
                <a href="add_template.php" class="btn btn-primary">Add Your First Template</a>
            </div>
            </div>
        <?php else: ?>
            <div class="template-grid">
                <?php foreach ($templates as $template): ?>
                <div class="template-card">
                    <div class="template-header">
                        <div>
                            <div class="template-name"><?php echo htmlspecialchars($template['name']); ?></div>
                            <div class="template-folder"><?php echo htmlspecialchars($template['folder_name']); ?></div>
                        </div>
                        <span class="badge <?php echo $template['is_active'] ? 'badge-active' : 'badge-suspended'; ?>">
                            <?php echo $template['is_active'] ? 'Active' : 'Inactive'; ?>
                        </span>
                    </div>
                    
                    <?php if ($template['description']): ?>
                    <div class="template-description">
                        <?php echo htmlspecialchars($template['description']); ?>
                    </div>
                    <?php endif; ?>
                    
                    <div class="template-footer">
                        <small style="color: var(--gray);">
                            Created: <?php echo date('M d, Y', strtotime($template['created_at'])); ?>
                        </small>
                        <a href="edit_template.php?id=<?php echo $template['id']; ?>" class="btn btn-primary btn-sm">Edit</a>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
