<?php
$configPath = __DIR__ . '/config/database.php';
if (!file_exists($configPath)) {
    die('Error: Configuration file not found. Please ensure all files are uploaded correctly.<br>Expected path: ' . htmlspecialchars($configPath));
}
require_once $configPath;

$configFile = __DIR__ . '/config/config.php';
if (!file_exists($configFile)) {
    die('Error: Config file not found. Please ensure all files are uploaded correctly.<br>Expected path: ' . htmlspecialchars($configFile));
}
require_once $configFile;

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = sanitizeInput($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    try {
        $conn = getDBConnection();
        
        // Initialize database if tables don't exist
        $result = $conn->query("SHOW TABLES LIKE 'admin_users'");
        if (!$result || $result->num_rows == 0) {
            initDatabase();
        }
        
        $stmt = $conn->prepare("SELECT id, username, password FROM admin_users WHERE username = ?");
        if (!$stmt) {
            throw new Exception("Database query failed: " . $conn->error);
        }
        
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();
            if (password_verify($password, $user['password'])) {
                $_SESSION['admin_logged_in'] = true;
                $_SESSION['admin_id'] = $user['id'];
                $_SESSION['admin_username'] = $user['username'];
                
                // Ensure session is saved before redirect
                session_write_close();
                
                header('Location: index.php');
                exit;
            }
        }
        
        $error = 'Invalid username or password';
        $conn->close();
    } catch (Exception $e) {
        $error = 'Database Error: ' . $e->getMessage();
        if (isset($conn)) {
            $conn->close();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - 405 Control Panel</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            background: #0a0a0f;
            background-image: 
                radial-gradient(circle at 20% 50%, rgba(6, 182, 212, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(20, 184, 166, 0.1) 0%, transparent 50%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
            position: relative;
            overflow: hidden;
        }
        body::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(6, 182, 212, 0.05) 0%, transparent 70%);
            animation: pulse 8s ease-in-out infinite;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); opacity: 0.5; }
            50% { transform: scale(1.1); opacity: 0.8; }
        }
        .login-wrapper {
            width: 100%;
            max-width: 420px;
            position: relative;
            z-index: 1;
        }
        .login-card {
            background: rgba(21, 21, 32, 0.8);
            backdrop-filter: blur(15px);
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5), 0 0 40px rgba(6, 182, 212, 0.2);
            border: 1px solid rgba(6, 182, 212, 0.3);
            position: relative;
            overflow: hidden;
        }
        .login-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, transparent, #06b6d4, transparent);
            animation: shine 3s infinite;
        }
        @keyframes shine {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        .login-logo {
            width: 64px;
            height: 64px;
            background: linear-gradient(135deg, #06b6d4 0%, #14b8a6 100%);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 1.75rem;
            color: white;
            font-weight: 700;
            box-shadow: 0 0 30px rgba(6, 182, 212, 0.5);
            position: relative;
        }
        .login-logo::after {
            content: '';
            position: absolute;
            inset: -2px;
            border-radius: 12px;
            padding: 2px;
            background: linear-gradient(135deg, #06b6d4, #14b8a6);
            -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
            -webkit-mask-composite: xor;
            mask-composite: exclude;
            opacity: 0.5;
        }
        .login-header h1 {
            font-size: 1.75rem;
            font-weight: 700;
            color: #e8e8f0;
            margin-bottom: 0.5rem;
            text-shadow: 0 0 15px rgba(6, 182, 212, 0.4);
        }
        .login-header p {
            color: #b0b0c0;
            font-size: 0.875rem;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #b0b0c0;
            font-size: 0.875rem;
        }
        .form-control {
            width: 100%;
            padding: 0.875rem 1rem;
            font-size: 0.9375rem;
            border: 1px solid rgba(6, 182, 212, 0.3);
            border-radius: 8px;
            transition: all 0.3s;
            background: rgba(15, 15, 21, 0.6);
            backdrop-filter: blur(10px);
            color: #e8e8f0;
        }
        .form-control:focus {
            outline: none;
            border-color: #06b6d4;
            box-shadow: 0 0 0 3px rgba(6, 182, 212, 0.3), 0 0 20px rgba(6, 182, 212, 0.2);
            background: rgba(15, 15, 21, 0.8);
        }
        .form-control::placeholder {
            color: #707080;
        }
        .btn-login {
            width: 100%;
            padding: 0.875rem;
            background: linear-gradient(135deg, #06b6d4 0%, #14b8a6 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 0.9375rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 0.5rem;
            box-shadow: 0 4px 15px rgba(6, 182, 212, 0.4);
            position: relative;
            overflow: hidden;
        }
        .btn-login::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        .btn-login:hover::before {
            width: 300px;
            height: 300px;
        }
        .btn-login:hover {
            background: linear-gradient(135deg, #22d3ee 0%, #06b6d4 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 25px rgba(6, 182, 212, 0.5);
        }
        .alert-error {
            background: rgba(255, 51, 102, 0.15);
            color: #ff3366;
            padding: 0.875rem 1rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            border: 1px solid rgba(255, 51, 102, 0.3);
            display: flex;
            align-items: center;
            gap: 0.5rem;
            box-shadow: 0 0 15px rgba(255, 51, 102, 0.2);
        }
        .login-footer {
            text-align: center;
            margin-top: 2rem;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(6, 182, 212, 0.2);
        }
        .login-footer p {
            color: #b0b0c0;
            font-size: 0.8125rem;
        }
        .login-footer strong {
            color: #06b6d4;
        }
        .input-icon {
            position: relative;
        }
        .input-icon input {
            padding-left: 2.5rem;
        }
        .input-icon::before {
            content: '';
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            width: 1.25rem;
            height: 1.25rem;
            opacity: 0.5;
        }
    </style>
</head>
<body>
    <div class="login-wrapper">
        <div class="login-card">
            <div class="login-header">
                <div class="login-logo">405</div>
                <h1>Welcome Back</h1>
                <p>Sign in to your admin account</p>
            </div>
            
            <?php if ($error): ?>
                <div class="alert-error">
                    <span>⚠️</span>
                    <span><?php echo htmlspecialchars($error); ?></span>
                </div>
            <?php endif; ?>
            
            <form method="POST" id="loginForm">
                <div class="form-group">
                    <label class="form-label">Username</label>
                    <input type="text" name="username" class="form-control" placeholder="Enter your username" required autofocus>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" placeholder="Enter your password" required>
                </div>
                
                <button type="submit" class="btn-login">Sign In</button>
            </form>
            
            <div class="login-footer">
                <p>Default credentials: <strong>admin</strong> / <strong>admin123</strong></p>
                <p style="margin-top: 0.5rem; color: #ff3366; font-size: 0.75rem;">⚠️ Change default password after first login</p>
            </div>
        </div>
    </div>
    
    <script>
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const btn = this.querySelector('button[type="submit"]');
            btn.disabled = true;
            btn.textContent = 'Signing in...';
        });
    </script>
</body>
</html>
