<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/config/config.php';
requireLogin();

try {
    $conn = getDBConnection();
    
    // Initialize database if tables don't exist
    $result = $conn->query("SHOW TABLES LIKE 'clients'");
    if (!$result || $result->num_rows == 0) {
        initDatabase();
    }
    
    // Get statistics with error handling
    $totalClients = 0;
    $activeClients = 0;
    $pendingClients = 0;
    $totalTemplates = 0;
    $recentClients = [];
    
    $result = $conn->query("SELECT COUNT(*) as count FROM clients");
    if ($result) {
        $totalClients = $result->fetch_assoc()['count'] ?? 0;
    }
    
    $result = $conn->query("SELECT COUNT(*) as count FROM clients WHERE status = 'active'");
    if ($result) {
        $activeClients = $result->fetch_assoc()['count'] ?? 0;
    }
    
    $result = $conn->query("SELECT COUNT(*) as count FROM clients WHERE status = 'pending'");
    if ($result) {
        $pendingClients = $result->fetch_assoc()['count'] ?? 0;
    }
    
    $result = $conn->query("SELECT COUNT(*) as count FROM templates WHERE is_active = 1");
    if ($result) {
        $totalTemplates = $result->fetch_assoc()['count'] ?? 0;
    }
    
    // Get recent clients
    $result = $conn->query("SELECT * FROM clients ORDER BY created_at DESC LIMIT 10");
    if ($result) {
        $recentClients = $result->fetch_all(MYSQLI_ASSOC);
    }
    
    $conn->close();
} catch (Exception $e) {
    die("Database Error: " . htmlspecialchars($e->getMessage()) . "<br>Please check your database configuration in config/database.php");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - WHM Admin Panel</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        .table-actions {
            display: flex;
            gap: 10px;
        }
        .table tbody tr {
            position: relative;
        }
        .table tbody tr::after {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 2px;
            background: var(--accent-cyan);
            opacity: 0;
            transition: opacity 0.3s;
        }
        .table tbody tr:hover::after {
            opacity: 1;
        }
        code {
            background: rgba(6, 182, 212, 0.15);
            border: 1px solid rgba(6, 182, 212, 0.3);
        }
    </style>
</head>
<body>
    <div class="admin-header">
        <h1>Admin Panel</h1>
        <div class="user-info">
            <span><?php echo htmlspecialchars($_SESSION['admin_username']); ?></span>
            <a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
        </div>
    </div>
    
    <div class="container">
        <div class="dashboard-header">
            <div class="dashboard-title">
                <h1>Dashboard</h1>
                <p>Manage clients and templates</p>
            </div>
            <div class="quick-actions">
                <a href="add_client.php" class="btn btn-primary">Add Client</a>
                <a href="manage_clients.php" class="btn btn-primary">Manage Clients</a>
                <a href="manage_templates.php" class="btn btn-primary">Templates</a>
                <a href="installation_history.php" class="btn btn-primary">Installation History</a>
                <a href="download_installer.php" class="btn btn-success">Download Installer</a>
                <a href="system_status.php" class="btn btn-primary">System Status</a>
                <a href="settings.php" class="btn btn-primary">Settings</a>
            </div>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card visitors">
                <div class="stat-card-header">
                    <span class="stat-card-title">Total Clients</span>
                    <div class="stat-card-icon">👥</div>
                </div>
                <div class="stat-card-value"><?php echo $totalClients; ?></div>
                <div class="stat-card-change">
                    <span>All registered</span>
                </div>
            </div>
            
            <div class="stat-card logins">
                <div class="stat-card-header">
                    <span class="stat-card-title">Active Clients</span>
                    <div class="stat-card-icon">✓</div>
                </div>
                <div class="stat-card-value"><?php echo $activeClients; ?></div>
                <div class="stat-card-change">
                    <span>Currently active</span>
                </div>
            </div>
            
            <div class="stat-card cards">
                <div class="stat-card-header">
                    <span class="stat-card-title">Pending</span>
                    <div class="stat-card-icon">⏱</div>
                </div>
                <div class="stat-card-value"><?php echo $pendingClients; ?></div>
                <div class="stat-card-change">
                    <span>Awaiting install</span>
                </div>
            </div>
            
            <div class="stat-card blocked">
                <div class="stat-card-header">
                    <span class="stat-card-title">Templates</span>
                    <div class="stat-card-icon">📦</div>
                </div>
                <div class="stat-card-value"><?php echo $totalTemplates; ?></div>
                <div class="stat-card-change">
                    <span>Available</span>
                </div>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h2>Recent Clients</h2>
                <a href="manage_clients.php" class="btn btn-primary btn-sm">View All</a>
            </div>
            <div class="table-wrapper">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Domain</th>
                            <th>Template</th>
                            <th>API Key</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($recentClients)): ?>
                        <tr>
                            <td colspan="6" class="empty-state">
                                <div class="empty-state-icon">📭</div>
                                <p>No clients yet. Add your first client to get started.</p>
                            </td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($recentClients as $client): ?>
                        <tr>
                            <td>
                                <strong><?php echo htmlspecialchars($client['domain']); ?></strong>
                            </td>
                            <td>
                                <span class="badge badge-active"><?php echo htmlspecialchars($client['template_selected']); ?></span>
                            </td>
                            <td>
                                <div style="display: flex; align-items: center; gap: 8px; flex-wrap: wrap;">
                                    <code style="font-size: 10px; max-width: 180px; overflow: hidden; text-overflow: ellipsis; display: inline-block; font-family: 'Courier New', monospace;">
                                        <?php echo htmlspecialchars($client['api_key']); ?>
                                    </code>
                                    <button class="btn btn-sm" onclick="copyToClipboard('<?php echo htmlspecialchars($client['api_key']); ?>')" title="Copy" style="padding: 5px 12px; font-size: 11px; background: rgba(6, 182, 212, 0.15); border: 1px solid rgba(6, 182, 212, 0.4); color: var(--accent-cyan);">Copy</button>
                                </div>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo $client['status']; ?>">
                                    <?php echo ucfirst($client['status']); ?>
                                </span>
                            </td>
                            <td style="color: var(--text-secondary); font-size: 12px;"><?php echo date('M d, Y H:i', strtotime($client['created_at'])); ?></td>
                            <td>
                                <div class="table-actions">
                                    <a href="edit_client.php?id=<?php echo $client['id']; ?>" class="btn btn-primary btn-sm">Edit</a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                var btn = event.target;
                var original = btn.textContent;
                btn.textContent = 'Copied!';
                btn.style.background = '#2ecc71';
                setTimeout(function() {
                    btn.textContent = original;
                    btn.style.background = '';
                }, 1500);
            });
        }
    </script>
</body>
</html>
