<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/config/config.php';
requireLogin();

$type = $_GET['type'] ?? 'clients';
$format = $_GET['format'] ?? 'csv';

$conn = getDBConnection();

if ($type === 'clients') {
    $data = $conn->query("SELECT * FROM clients ORDER BY created_at DESC")->fetch_all(MYSQLI_ASSOC);
    $filename = 'clients_' . date('Y-m-d_His') . '.' . $format;
    
    if ($format === 'csv') {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        
        $output = fopen('php://output', 'w');
        fputcsv($output, ['ID', 'Domain', 'API Key', 'Template', 'Status', 'Created At', 'Updated At']);
        
        foreach ($data as $row) {
            fputcsv($output, [
                $row['id'],
                $row['domain'],
                $row['api_key'],
                $row['template_selected'],
                $row['status'],
                $row['created_at'],
                $row['updated_at']
            ]);
        }
        fclose($output);
    } elseif ($format === 'json') {
        header('Content-Type: application/json');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        echo json_encode($data, JSON_PRETTY_PRINT);
    }
} elseif ($type === 'templates') {
    $data = $conn->query("SELECT * FROM templates ORDER BY created_at DESC")->fetch_all(MYSQLI_ASSOC);
    $filename = 'templates_' . date('Y-m-d_His') . '.' . $format;
    
    if ($format === 'csv') {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        
        $output = fopen('php://output', 'w');
        fputcsv($output, ['ID', 'Name', 'Folder Name', 'Description', 'Zip File', 'Active', 'Created At']);
        
        foreach ($data as $row) {
            fputcsv($output, [
                $row['id'],
                $row['name'],
                $row['folder_name'],
                $row['description'] ?? '',
                $row['zip_file_path'],
                $row['is_active'] ? 'Yes' : 'No',
                $row['created_at']
            ]);
        }
        fclose($output);
    } elseif ($format === 'json') {
        header('Content-Type: application/json');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        echo json_encode($data, JSON_PRETTY_PRINT);
    }
} elseif ($type === 'installations') {
    $data = $conn->query("SELECT i.*, c.domain, t.name as template_name 
                          FROM installations i
                          LEFT JOIN clients c ON i.client_id = c.id
                          LEFT JOIN templates t ON i.template_id = t.id
                          ORDER BY i.install_date DESC")->fetch_all(MYSQLI_ASSOC);
    $filename = 'installations_' . date('Y-m-d_His') . '.' . $format;
    
    if ($format === 'csv') {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        
        $output = fopen('php://output', 'w');
        fputcsv($output, ['ID', 'Domain', 'Template', 'Status', 'Date', 'Error Message']);
        
        foreach ($data as $row) {
            fputcsv($output, [
                $row['id'],
                $row['domain'] ?? 'N/A',
                $row['template_name'] ?? 'N/A',
                $row['install_status'],
                $row['install_date'],
                $row['error_message'] ?? ''
            ]);
        }
        fclose($output);
    } elseif ($format === 'json') {
        header('Content-Type: application/json');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        echo json_encode($data, JSON_PRETTY_PRINT);
    }
}

$conn->close();
exit;
?>

