<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/config/config.php';
requireLogin();

$id = $_GET['id'] ?? 0;
$success = '';
$error = '';

$conn = getDBConnection();
$template = $conn->query("SELECT * FROM templates WHERE id = $id")->fetch_assoc();

if (!$template) {
    die('Template not found');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = sanitizeInput($_POST['name'] ?? '');
    $folderName = sanitizeInput($_POST['folder_name'] ?? '');
    $description = sanitizeInput($_POST['description'] ?? '');
    $isActive = isset($_POST['is_active']) ? 1 : 0;
    
    // Handle file upload if new file provided
    if (isset($_FILES['zip_file']) && $_FILES['zip_file']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = TEMPLATES_DIR;
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        // Delete old file
        $oldFile = TEMPLATES_DIR . $template['zip_file_path'];
        if (file_exists($oldFile)) {
            unlink($oldFile);
        }
        
        $fileName = $folderName . '.zip';
        $uploadPath = $uploadDir . $fileName;
        
        if (!move_uploaded_file($_FILES['zip_file']['tmp_name'], $uploadPath)) {
            $error = 'Failed to upload file';
        } else {
            $zipFilePath = $fileName;
        }
    } else {
        $zipFilePath = $template['zip_file_path'];
    }
    
    if (empty($error)) {
        $stmt = $conn->prepare("UPDATE templates SET name = ?, folder_name = ?, description = ?, zip_file_path = ?, is_active = ? WHERE id = ?");
        $stmt->bind_param("ssssii", $name, $folderName, $description, $zipFilePath, $isActive, $id);
        
        if ($stmt->execute()) {
            $success = 'Template updated successfully!';
            $template = $conn->query("SELECT * FROM templates WHERE id = $id")->fetch_assoc();
        } else {
            $error = 'Failed to update template';
        }
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Template - WHM Admin</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        .file-info {
            background: var(--light);
            padding: 1rem;
            border-radius: var(--radius);
            margin: 1rem 0;
        }
        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        input[type="checkbox"] {
            width: 1.25rem;
            height: 1.25rem;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="admin-header">
        <h1>Edit Template</h1>
        <div class="user-info">
            <a href="manage_templates.php" class="btn btn-primary btn-sm">Back to Templates</a>
        </div>
    </div>
    
    <div class="container">
        <div class="card" style="max-width: 700px; margin: 0 auto;">
            <?php if ($success): ?>
                <div class="alert alert-success">
                    <span>✅</span>
                    <span><?php echo $success; ?></span>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <span>❌</span>
                    <span><?php echo htmlspecialchars($error); ?></span>
                </div>
            <?php endif; ?>
            
            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label class="form-label">Template Name</label>
                    <input type="text" name="name" class="form-control" value="<?php echo htmlspecialchars($template['name']); ?>" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Folder Name</label>
                    <input type="text" name="folder_name" class="form-control" value="<?php echo htmlspecialchars($template['folder_name']); ?>" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="3"><?php echo htmlspecialchars($template['description']); ?></textarea>
                </div>
                
                <div class="file-info">
                    <strong>Current File:</strong> <code><?php echo htmlspecialchars($template['zip_file_path']); ?></code>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Upload New ZIP File (Optional)</label>
                    <input type="file" name="zip_file" class="form-control" accept=".zip">
                    <small style="color: var(--gray); font-size: 0.8125rem; margin-top: 0.25rem; display: block;">
                        Leave empty to keep current file
                    </small>
                </div>
                
                <div class="form-group">
                    <div class="checkbox-group">
                        <input type="checkbox" name="is_active" value="1" id="is_active" <?php echo $template['is_active'] ? 'checked' : ''; ?>>
                        <label for="is_active" class="form-label" style="margin: 0; cursor: pointer;">Active (Template will be available for clients)</label>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%; padding: 0.875rem;">
                    Update Template
                </button>
            </form>
        </div>
    </div>
</body>
</html>
