<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/config/config.php';
requireLogin();

$id = $_GET['id'] ?? 0;
$success = '';
$error = '';

$conn = getDBConnection();
$client = $conn->query("SELECT * FROM clients WHERE id = $id")->fetch_assoc();

if (!$client) {
    die('Client not found');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $domain = sanitizeInput($_POST['domain'] ?? '');
    $template = sanitizeInput($_POST['template'] ?? '');
    $status = sanitizeInput($_POST['status'] ?? 'pending');
    
    $templates = $conn->query("SELECT * FROM templates WHERE is_active = 1")->fetch_all(MYSQLI_ASSOC);
    
    $stmt = $conn->prepare("UPDATE clients SET domain = ?, template_selected = ?, status = ? WHERE id = ?");
    $stmt->bind_param("sssi", $domain, $template, $status, $id);
    
    if ($stmt->execute()) {
        $success = 'Client updated successfully!';
        $client = $conn->query("SELECT * FROM clients WHERE id = $id")->fetch_assoc();
    } else {
        $error = 'Failed to update client';
    }
}

$templates = $conn->query("SELECT * FROM templates WHERE is_active = 1")->fetch_all(MYSQLI_ASSOC);
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Client - WHM Admin</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        .api-key-display {
            background: rgba(6, 182, 212, 0.1);
            backdrop-filter: blur(10px);
            border: 2px solid var(--accent-cyan);
            color: white;
            padding: 1.75rem;
            border-radius: 12px;
            margin: 1.75rem 0;
            box-shadow: 0 0 30px rgba(6, 182, 212, 0.3);
        }
        .api-key-display h3 {
            color: var(--accent-cyan);
            margin-bottom: 0.75rem;
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            font-weight: 600;
            text-shadow: 0 0 10px rgba(6, 182, 212, 0.4);
        }
        .api-key-value {
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            word-break: break-all;
            background: rgba(6, 182, 212, 0.15);
            padding: 1.25rem;
            border-radius: 8px;
            border: 1px solid rgba(6, 182, 212, 0.3);
            color: #fff;
            box-shadow: 0 0 15px rgba(6, 182, 212, 0.2);
        }
        .copy-api-btn {
            background: linear-gradient(135deg, var(--accent-cyan) 0%, var(--accent-teal) 100%);
            color: white;
            border: none;
            padding: 0.625rem 1.25rem;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 500;
            margin-top: 0.75rem;
            transition: all 0.3s;
            font-size: 13px;
            box-shadow: 0 4px 15px rgba(6, 182, 212, 0.4);
        }
        .copy-api-btn:hover {
            background: linear-gradient(135deg, #22d3ee 0%, var(--accent-cyan) 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 25px rgba(6, 182, 212, 0.5);
        }
    </style>
</head>
<body>
    <div class="admin-header">
        <h1>Edit Client</h1>
        <div class="user-info">
            <a href="index.php" class="btn btn-primary btn-sm">Back to Dashboard</a>
        </div>
    </div>
    
    <div class="container">
        <div class="card" style="max-width: 700px; margin: 0 auto;">
            <?php if ($success): ?>
                <div class="alert alert-success">
                    <span><?php echo $success; ?></span>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <span><?php echo htmlspecialchars($error); ?></span>
                </div>
            <?php endif; ?>
            
            <div class="api-key-display">
                <h3>API Key</h3>
                <div class="api-key-value"><?php echo htmlspecialchars($client['api_key']); ?></div>
                <button class="copy-api-btn" onclick="copyApiKey('<?php echo htmlspecialchars($client['api_key']); ?>')">Copy API Key</button>
            </div>
            
            <form method="POST">
                <div class="form-group">
                    <label class="form-label">Domain</label>
                    <input type="text" name="domain" class="form-control" value="<?php echo htmlspecialchars($client['domain']); ?>" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Template</label>
                    <select name="template" class="form-control" required>
                        <?php foreach ($templates as $template): ?>
                            <option value="<?php echo htmlspecialchars($template['folder_name']); ?>" 
                                    <?php echo $client['template_selected'] === $template['folder_name'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($template['name']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-control">
                        <option value="pending" <?php echo $client['status'] === 'pending' ? 'selected' : ''; ?>>Pending</option>
                        <option value="active" <?php echo $client['status'] === 'active' ? 'selected' : ''; ?>>Active</option>
                        <option value="suspended" <?php echo $client['status'] === 'suspended' ? 'selected' : ''; ?>>Suspended</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%; padding: 0.875rem;">
                    Update Client
                </button>
            </form>
        </div>
    </div>
    
    <script>
        function copyApiKey(text) {
            navigator.clipboard.writeText(text).then(function() {
                const btn = event.target;
                const originalText = btn.textContent;
                btn.textContent = 'Copied!';
                btn.style.background = '#14b8a6';
                btn.style.color = 'white';
                setTimeout(() => {
                    btn.textContent = originalText;
                    btn.style.background = '';
                    btn.style.color = '';
                }, 2000);
            });
        }
    </script>
</body>
</html>
