<?php
require_once __DIR__ . '/config/config.php';
requireLogin();

$installerFile = __DIR__ . '/installers/installer.php';

if (file_exists($installerFile)) {
    // Read installer.php content
    $content = file_get_contents($installerFile);
    
    // Replace ADMIN_SERVER_URL with actual URL from config
    $adminUrl = ADMIN_BASE_URL;
    $content = preg_replace(
        "/define\('ADMIN_SERVER_URL',\s*'[^']*'\);/",
        "define('ADMIN_SERVER_URL', '$adminUrl');",
        $content
    );
    
    // Send file
    header('Content-Type: application/php');
    header('Content-Disposition: attachment; filename="installer.php"');
    header('Content-Length: ' . strlen($content));
    echo $content;
} else {
    die('Installer file not found');
}
?>

