<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

echo "<h1>Debug Login Process</h1>";
echo "<pre>";

echo "1. Checking config files...\n";
$configPath = __DIR__ . '/config/database.php';
if (!file_exists($configPath)) {
    die("ERROR: database.php not found at: $configPath\n");
}
echo "✓ database.php found\n";

$configFile = __DIR__ . '/config/config.php';
if (!file_exists($configFile)) {
    die("ERROR: config.php not found at: $configFile\n");
}
echo "✓ config.php found\n";

require_once $configPath;
require_once $configFile;

echo "\n2. Testing database connection...\n";
try {
    $conn = getDBConnection();
    echo "✓ Database connection successful\n";
    
    echo "\n3. Checking admin_users table...\n";
    $result = $conn->query("SHOW TABLES LIKE 'admin_users'");
    if ($result && $result->num_rows > 0) {
        echo "✓ Table admin_users exists\n";
        
        echo "\n4. Checking admin user...\n";
        $result = $conn->query("SELECT id, username FROM admin_users WHERE username = 'admin'");
        if ($result && $result->num_rows > 0) {
            $user = $result->fetch_assoc();
            echo "✓ Admin user found (ID: {$user['id']}, Username: {$user['username']})\n";
        } else {
            echo "✗ Admin user NOT FOUND!\n";
            echo "Creating default admin user...\n";
            $password = password_hash('admin123', PASSWORD_DEFAULT);
            $conn->query("INSERT INTO admin_users (username, password, email) VALUES ('admin', '$password', 'admin@example.com')");
            echo "✓ Default admin user created\n";
        }
    } else {
        echo "✗ Table admin_users NOT FOUND!\n";
        echo "Initializing database...\n";
        initDatabase();
        echo "✓ Database initialized\n";
    }
    $conn->close();
} catch (Exception $e) {
    echo "✗ ERROR: " . $e->getMessage() . "\n";
    echo "\nPlease check:\n";
    echo "- Database 'whm_admin' exists\n";
    echo "- DB_USER and DB_PASS in config/database.php are correct\n";
    echo "- User has privileges on database\n";
}

echo "\n5. Testing session...\n";
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}
echo "✓ Session started\n";
echo "Session ID: " . session_id() . "\n";

echo "\n6. Testing index.php...\n";
$indexPath = __DIR__ . '/index.php';
if (file_exists($indexPath)) {
    echo "✓ index.php exists\n";
    
    echo "\n7. Simulating login...\n";
    $_SESSION['admin_logged_in'] = true;
    $_SESSION['admin_id'] = 1;
    $_SESSION['admin_username'] = 'admin';
    echo "✓ Session variables set\n";
    echo "Session data: " . print_r($_SESSION, true) . "\n";
    
    echo "\n8. Testing redirect to index.php...\n";
    echo "If you see this, index.php should work.\n";
    echo "Try accessing: <a href='index.php'>index.php</a>\n";
} else {
    echo "✗ index.php NOT FOUND!\n";
}

echo "\n</pre>";
echo "<hr>";
echo "<h2>Next Steps:</h2>";
echo "<ol>";
echo "<li>If database/user not found, run: <a href='tools/create_db_auto.php'>tools/create_db_auto.php</a></li>";
echo "<li>If config missing, run: <a href='tools/fix_config.php'>tools/fix_config.php</a></li>";
echo "<li>Try login again: <a href='login.php'>login.php</a></li>";
echo "<li>Check files: <a href='check_files.php'>check_files.php</a></li>";
echo "</ol>";
?>

