<?php
// Database Configuration
// Untuk Shared Hosting (cPanel): Gunakan kredensial dari cPanel MySQL
// Untuk VPS/Dedicated: Sesuaikan dengan konfigurasi server Anda

// Database Configuration
// Untuk Localhost (XAMPP/MAMP): Gunakan setting default di bawah
// Untuk Shared Hosting (cPanel): Ganti dengan kredensial dari cPanel MySQL
// Untuk VPS/Dedicated: Sesuaikan dengan konfigurasi server Anda

define('DB_HOST', 'localhost');  // Biasanya 'localhost'
define('DB_USER', 'root');  // ⚠️ EDIT INI: Ganti dengan username_database dari cPanel MySQL
define('DB_PASS', '');  // ⚠️ EDIT INI: Ganti dengan password_database dari cPanel MySQL
define('DB_NAME', 'whm_admin');  // Nama database

function createDatabaseIfNotExists() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS);
    
    if ($conn->connect_error) {
        return false;
    }
    
    $result = $conn->query("SHOW DATABASES LIKE '" . DB_NAME . "'");
    
    if ($result && $result->num_rows == 0) {
        $sql = "CREATE DATABASE `" . DB_NAME . "` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
        @$conn->query($sql);
    }
    
    $conn->close();
    return true;
}

function getDBConnection() {
    @createDatabaseIfNotExists();
    
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        if (strpos($conn->connect_error, "Unknown database") !== false) {
            die("Database '" . DB_NAME . "' tidak ditemukan. Silakan buat database terlebih dahulu via cPanel MySQL atau phpMyAdmin.");
        }
        die("Connection failed: " . $conn->connect_error);
    }
    
    return $conn;
}

// Initialize database tables
function initDatabase() {
    try {
        $conn = getDBConnection();
        
        // Set charset
        $conn->set_charset("utf8mb4");
        
        // Create clients table
        $sql = "CREATE TABLE IF NOT EXISTS clients (
            id INT PRIMARY KEY AUTO_INCREMENT,
            domain VARCHAR(255) UNIQUE NOT NULL,
            api_key VARCHAR(64) UNIQUE NOT NULL,
            template_selected VARCHAR(50) NOT NULL,
            status ENUM('pending', 'active', 'suspended') DEFAULT 'pending',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        $conn->query($sql);
        
        // Create templates table
        $sql = "CREATE TABLE IF NOT EXISTS templates (
            id INT PRIMARY KEY AUTO_INCREMENT,
            name VARCHAR(100) NOT NULL,
            folder_name VARCHAR(100) NOT NULL,
            description TEXT,
            zip_file_path VARCHAR(255) NOT NULL,
            is_active BOOLEAN DEFAULT 1,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        $conn->query($sql);
        
        // Create installations table (handle foreign key gracefully)
        $sql = "CREATE TABLE IF NOT EXISTS installations (
            id INT PRIMARY KEY AUTO_INCREMENT,
            client_id INT,
            api_key VARCHAR(64),
            template_id INT,
            install_status ENUM('pending', 'downloading', 'extracting', 'completed', 'failed') DEFAULT 'pending',
            install_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            error_message TEXT,
            INDEX idx_client_id (client_id),
            INDEX idx_api_key (api_key)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        $conn->query($sql);
        
        // Try to add foreign key if it doesn't exist
        $fkCheck = $conn->query("SELECT COUNT(*) as count FROM information_schema.KEY_COLUMN_USAGE 
            WHERE TABLE_SCHEMA = DATABASE() 
            AND TABLE_NAME = 'installations' 
            AND CONSTRAINT_NAME = 'installations_ibfk_1'");
        if ($fkCheck && $fkCheck->num_rows > 0) {
            $fkExists = $fkCheck->fetch_assoc()['count'] > 0;
            if (!$fkExists) {
                // Try to add foreign key
                @$conn->query("ALTER TABLE installations 
                    ADD CONSTRAINT installations_ibfk_1 
                    FOREIGN KEY (client_id) REFERENCES clients(id) ON DELETE CASCADE");
            }
        }
        
        // Create admin_users table
        $sql = "CREATE TABLE IF NOT EXISTS admin_users (
            id INT PRIMARY KEY AUTO_INCREMENT,
            username VARCHAR(50) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            email VARCHAR(100),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        $conn->query($sql);
        
        // Insert default admin if not exists
        $checkAdmin = $conn->query("SELECT COUNT(*) as count FROM admin_users WHERE username = 'admin'");
        if ($checkAdmin) {
            $row = $checkAdmin->fetch_assoc();
            if ($row['count'] == 0) {
                $password = password_hash('admin123', PASSWORD_DEFAULT);
                $conn->query("INSERT INTO admin_users (username, password, email) VALUES ('admin', '$password', 'admin@example.com')");
            }
        }
        
        $conn->close();
        return true;
    } catch (Exception $e) {
        // Silent fail - will retry on next access
        return false;
    }
}

// Call init on include
initDatabase();
?>

