<?php
function getBaseUrl() {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $scriptDir = dirname($_SERVER['SCRIPT_NAME']);
    
    if (strpos($scriptDir, '/405server') !== false) {
        $basePath = rtrim($scriptDir, '/');
    } elseif (strpos($scriptDir, '/server-admin') !== false) {
        $basePath = rtrim($scriptDir, '/');
    } else {
        $configDir = dirname(__FILE__);
        $parentDir = basename(dirname($configDir));
        if ($parentDir === '405server' || $parentDir === 'server-admin') {
            $basePath = dirname($scriptDir) . '/' . $parentDir;
        } else {
            $basePath = '/server-admin';
        }
    }
    
    return $protocol . '://' . $host . $basePath;
}

$manualBaseUrl = 'https://stock-market-idea.com/server-admin';

define('ADMIN_BASE_URL', $manualBaseUrl !== null ? $manualBaseUrl : getBaseUrl());
define('TEMPLATES_DIR', __DIR__ . '/../templates/');
define('INSTALLER_DIR', __DIR__ . '/../installers/');
define('API_KEY_LENGTH', 32);
define('SESSION_NAME', 'whm_admin_session');
define('RATE_LIMIT_REQUESTS', 10);
define('API_KEY_EXPIRY_DAYS', 365);

date_default_timezone_set('Asia/Jakarta');

if (strpos($_SERVER['HTTP_HOST'], 'localhost') !== false || strpos($_SERVER['HTTP_HOST'], '127.0.0.1') !== false) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/../logs/php_errors.log');
}
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

function generateApiKey() {
    return bin2hex(random_bytes(API_KEY_LENGTH));
}

function sanitizeInput($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}
function requireLogin() {
    if (!isLoggedIn()) {
        $scriptDir = dirname($_SERVER['SCRIPT_NAME']);
        if (strpos($scriptDir, '/405server') !== false) {
            $loginUrl = '/405server/login.php';
        } elseif (strpos($scriptDir, '/server-admin') !== false) {
            $loginUrl = '/server-admin/login.php';
        } else {
            $loginUrl = 'login.php';
        }
        header('Location: ' . $loginUrl);
        exit;
    }
}

function autoSetup() {
    $dirs = [
        TEMPLATES_DIR,
        INSTALLER_DIR,
        __DIR__ . '/../assets/css',
        __DIR__ . '/../api',
        __DIR__ . '/../logs'
    ];
    
    foreach ($dirs as $dir) {
        if (!is_dir($dir)) {
            @mkdir($dir, 0755, true);
        }
    }
    
    $htaccessFile = TEMPLATES_DIR . '.htaccess';
    if (!file_exists($htaccessFile)) {
        $htaccessContent = "Options -Indexes\nDeny from all";
        @file_put_contents($htaccessFile, $htaccessContent);
    }
    
    $htaccessFile2 = INSTALLER_DIR . '.htaccess';
    if (!file_exists($htaccessFile2)) {
        $htaccessContent = "Options -Indexes\n";
        @file_put_contents($htaccessFile2, $htaccessContent);
    }
    
    $indexFile = TEMPLATES_DIR . 'index.php';
    if (!file_exists($indexFile)) {
        @file_put_contents($indexFile, "<?php\n// Directory access denied\n");
    }
    
    $requiredExtensions = ['mysqli', 'zip', 'json'];
    $missingExtensions = [];
    foreach ($requiredExtensions as $ext) {
        if (!extension_loaded($ext)) {
            $missingExtensions[] = $ext;
        }
    }
    
    return [
        'success' => empty($missingExtensions),
        'missing_extensions' => $missingExtensions,
        'directories_created' => true
    ];
}

$setupStatus = autoSetup();
?>

