<?php
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>File Checker - Server Admin</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        h1 { color: #333; }
        .file-check { padding: 10px; margin: 5px 0; border-radius: 4px; }
        .exists { background: #d4edda; color: #155724; }
        .missing { background: #f8d7da; color: #721c24; }
        .folder { background: #d1ecf1; color: #0c5460; font-weight: bold; margin-top: 15px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>File & Folder Checker</h1>
        <p>Memeriksa apakah semua file dan folder sudah ter-upload dengan benar...</p>
        
        <?php
        $baseDir = __DIR__;
        
        echo '<div class="folder">PHP VERSION:</div>';
        $phpVersion = PHP_VERSION;
        $phpMajor = (int)explode('.', $phpVersion)[0];
        $phpMinor = (int)explode('.', $phpVersion)[1];
        $phpOk = ($phpMajor >= 7 && $phpMinor >= 0);
        $phpRecommended = ($phpMajor >= 8 || ($phpMajor == 7 && $phpMinor >= 4));
        $class = $phpOk ? 'exists' : 'missing';
        $status = $phpOk ? '✓ OK (PHP ' . $phpVersion . ')' : '✗ TOO OLD (PHP ' . $phpVersion . ' - Need PHP 7.0+)';
        if ($phpRecommended && $phpOk) {
            $status = '✓ EXCELLENT (PHP ' . $phpVersion . ' - Recommended Version)';
        }
        echo "<div class='file-check $class'>$status</div>";
        
        echo '<div class="folder">PHP EXTENSIONS:</div>';
        $requiredExtensions = ['mysqli', 'zip', 'json', 'curl', 'openssl'];
        foreach ($requiredExtensions as $ext) {
            $loaded = extension_loaded($ext);
            $class = $loaded ? 'exists' : 'missing';
            $status = $loaded ? '✓ LOADED' : '✗ MISSING';
            echo "<div class='file-check $class'>$ext - $status</div>";
        }
        
        $requiredFiles = [
            'login.php',
            'index.php',
            'config/database.php',
            'config/config.php',
            'api/validate_key.php',
            'api/download_template.php',
            'installers/installer.php',
            '.htaccess'
        ];
        
        $requiredFolders = [
            'config',
            'api',
            'installers',
            'templates',
            'assets/css'
        ];
        
        echo '<div class="folder">FOLDERS:</div>';
        foreach ($requiredFolders as $folder) {
            $path = $baseDir . '/' . $folder;
            $exists = is_dir($path);
            $class = $exists ? 'exists' : 'missing';
            $status = $exists ? '✓ EXISTS' : '✗ MISSING';
            echo "<div class='file-check $class'>$folder/ - $status</div>";
        }
        
        echo '<div class="folder">FILES:</div>';
        foreach ($requiredFiles as $file) {
            $path = $baseDir . '/' . $file;
            $exists = file_exists($path);
            $class = $exists ? 'exists' : 'missing';
            $status = $exists ? '✓ EXISTS' : '✗ MISSING';
            echo "<div class='file-check $class'>$file - $status</div>";
        }
        
        $allExists = true;
        foreach ($requiredFiles as $file) {
            if (!file_exists($baseDir . '/' . $file)) {
                $allExists = false;
                break;
            }
        }
        foreach ($requiredFolders as $folder) {
            if (!is_dir($baseDir . '/' . $folder)) {
                $allExists = false;
                break;
            }
        }
        
        if ($allExists) {
            echo '<div style="margin-top: 20px; padding: 15px; background: #d4edda; color: #155724; border-radius: 4px;">';
            echo '<strong>✓ Semua file dan folder sudah ada!</strong><br>';
            echo 'Silakan <a href="login.php">klik di sini untuk login</a>';
            echo '</div>';
        } else {
            echo '<div style="margin-top: 20px; padding: 15px; background: #fff3cd; color: #856404; border-radius: 4px;">';
            echo '<strong>⚠ Beberapa file/folder masih missing!</strong><br>';
            echo 'Pastikan semua file dan folder sudah ter-upload dengan benar.';
            echo '</div>';
        }
        ?>
        
        <div style="margin-top: 20px; padding: 15px; background: #e7f3ff; border-radius: 4px;">
            <strong>Struktur yang benar:</strong><br>
            <code>public_html/server-admin/</code><br>
            <code>public_html/server-admin/config/</code><br>
            <code>public_html/server-admin/config/database.php</code><br>
            <code>public_html/server-admin/config/config.php</code>
        </div>
    </div>
</body>
</html>

