<?php
require_once '../config/database.php';
require_once '../config/config.php';

session_start();

$token = $_GET['token'] ?? '';

if (empty($token) || !isset($_SESSION['download_token_' . $token])) {
    http_response_code(403);
    die('Invalid or expired token');
}

$tokenData = $_SESSION['download_token_' . $token];

// Check token expiry
if (time() > $tokenData['expires']) {
    unset($_SESSION['download_token_' . $token]);
    http_response_code(403);
    die('Token expired');
}

$apiKey = $tokenData['api_key'];
$domain = $tokenData['domain'];

$conn = getDBConnection();

// Verify client again
$stmt = $conn->prepare("SELECT template_selected FROM clients WHERE api_key = ? AND domain = ?");
$stmt->bind_param("ss", $apiKey, $domain);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows !== 1) {
    http_response_code(403);
    die('Unauthorized');
}

$client = $result->fetch_assoc();
$templateName = $client['template_selected'];

// Get template path
$templateStmt = $conn->prepare("SELECT zip_file_path FROM templates WHERE folder_name = ? AND is_active = 1");
$templateStmt->bind_param("s", $templateName);
$templateStmt->execute();
$templateResult = $templateStmt->get_result();

if ($templateResult->num_rows !== 1) {
    http_response_code(404);
    die('Template not found');
}

$template = $templateResult->fetch_assoc();
$zipPath = TEMPLATES_DIR . $template['zip_file_path'];

if (!file_exists($zipPath)) {
    http_response_code(404);
    die('Template file not found');
}

// Update installation status
$updateStmt = $conn->prepare("UPDATE installations SET install_status = 'downloading' WHERE api_key = ? ORDER BY id DESC LIMIT 1");
$updateStmt->bind_param("s", $apiKey);
$updateStmt->execute();

$conn->close();

// Delete token after use (one-time use)
unset($_SESSION['download_token_' . $token]);

// Send file
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $templateName . '.zip"');
header('Content-Length: ' . filesize($zipPath));
header('Cache-Control: no-cache, must-revalidate');
header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');

readfile($zipPath);
exit;
?>

