<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/config/config.php';
requireLogin();

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = sanitizeInput($_POST['name'] ?? '');
    $folderName = sanitizeInput($_POST['folder_name'] ?? '');
    $description = sanitizeInput($_POST['description'] ?? '');
    
    // Handle file upload
    if (isset($_FILES['zip_file']) && $_FILES['zip_file']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = TEMPLATES_DIR;
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        $fileName = $folderName . '.zip';
        $uploadPath = $uploadDir . $fileName;
        
        if (move_uploaded_file($_FILES['zip_file']['tmp_name'], $uploadPath)) {
            $conn = getDBConnection();
            $stmt = $conn->prepare("INSERT INTO templates (name, folder_name, description, zip_file_path) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssss", $name, $folderName, $description, $fileName);
            
            if ($stmt->execute()) {
                $success = 'Template added successfully!';
            } else {
                $error = 'Failed to save template to database';
                unlink($uploadPath);
            }
            $conn->close();
        } else {
            $error = 'Failed to upload file';
        }
    } else {
        $error = 'Please select a ZIP file';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Template - WHM Admin</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        .file-upload-area {
            border: 2px dashed rgba(0, 212, 255, 0.3);
            border-radius: 12px;
            padding: 2.5rem;
            text-align: center;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            background: rgba(0, 212, 255, 0.03);
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }
        .file-upload-area::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(0, 212, 255, 0.1) 0%, transparent 70%);
            opacity: 0;
            transition: opacity 0.3s;
        }
        .file-upload-area:hover {
            border-color: var(--accent-blue);
            background: rgba(0, 212, 255, 0.08);
            box-shadow: 0 0 30px rgba(0, 212, 255, 0.2);
            transform: scale(1.02);
        }
        .file-upload-area:hover::before {
            opacity: 1;
        }
        .file-upload-area.dragover {
            border-color: var(--accent-blue);
            background: rgba(0, 212, 255, 0.15);
            box-shadow: 0 0 40px rgba(0, 212, 255, 0.4);
        }
        .file-upload-area p {
            color: var(--text-secondary);
            position: relative;
            z-index: 1;
        }
        .file-upload-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        input[type="file"] {
            display: none;
        }
        .file-name {
            margin-top: 1rem;
            color: var(--primary);
            font-weight: 500;
        }
    </style>
</head>
<body>
    <div class="admin-header">
        <h1>Add New Template</h1>
        <div class="user-info">
            <a href="manage_templates.php" class="btn btn-primary btn-sm">Back to Templates</a>
        </div>
    </div>
    
    <div class="container">
        <div class="card" style="max-width: 700px; margin: 0 auto;">
            <?php if ($success): ?>
                <div class="alert alert-success">
                    <span>✅</span>
                    <span><?php echo $success; ?></span>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <span>❌</span>
                    <span><?php echo htmlspecialchars($error); ?></span>
                </div>
            <?php endif; ?>
            
            <form method="POST" enctype="multipart/form-data" id="templateForm">
                <div class="form-group">
                    <label class="form-label">Template Name</label>
                    <input type="text" name="name" class="form-control" placeholder="Netflix Template" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Folder Name</label>
                    <input type="text" name="folder_name" class="form-control" placeholder="netflix" required>
                    <small style="color: var(--gray); font-size: 0.8125rem; margin-top: 0.25rem; display: block;">
                        Used as identifier (lowercase, no spaces, no special characters)
                    </small>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Description</label>
                    <textarea name="description" class="form-control" rows="3" placeholder="Template description..."></textarea>
                </div>
                
                <div class="form-group">
                    <label class="form-label">ZIP File</label>
                    <div class="file-upload-area" onclick="document.getElementById('zip_file').click()">
                        <div class="file-upload-icon">📦</div>
                        <p style="margin-bottom: 0.5rem; font-weight: 500; color: var(--text-primary);">Click to upload or drag and drop</p>
                        <p style="color: var(--text-muted); font-size: 0.875rem;">ZIP file (Max 50MB)</p>
                        <div class="file-name" id="fileName" style="display: none; color: var(--accent-blue); margin-top: 10px;"></div>
                    </div>
                    <input type="file" name="zip_file" id="zip_file" accept=".zip" required>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%; padding: 0.875rem;">
                    Upload Template
                </button>
            </form>
        </div>
    </div>
    
    <script>
        const fileInput = document.getElementById('zip_file');
        const fileName = document.getElementById('fileName');
        const uploadArea = document.querySelector('.file-upload-area');
        
        fileInput.addEventListener('change', function(e) {
            if (this.files.length > 0) {
                fileName.textContent = this.files[0].name;
                fileName.style.display = 'block';
                uploadArea.style.borderColor = 'var(--success)';
            }
        });
        
        uploadArea.addEventListener('dragover', function(e) {
            e.preventDefault();
            this.classList.add('dragover');
        });
        
        uploadArea.addEventListener('dragleave', function(e) {
            this.classList.remove('dragover');
        });
        
        uploadArea.addEventListener('drop', function(e) {
            e.preventDefault();
            this.classList.remove('dragover');
            if (e.dataTransfer.files.length > 0) {
                fileInput.files = e.dataTransfer.files;
                fileName.textContent = e.dataTransfer.files[0].name;
                fileName.style.display = 'block';
                uploadArea.style.borderColor = 'var(--success)';
            }
        });
    </script>
</body>
</html>
